<?php
// === CLOAKER GUARD (FINLAND & SWEDEN ONLY + SESSION CACHE) ===

// Session'ı en tepede başlatıyoruz ki kullanıcıyı hatırlayalım
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Veritabanı bilgileri (Whitelist kontrolü için)
$db_host_cloak = "localhost";
$db_name_cloak = "npnencypzt_1";
$db_user_cloak = "npnencypzt_1";
$db_pass_cloak = "XGMFLH2cQ=Iv";

// --- KULLANICI ZATEN ONAYLI MI? ---
// Eğer kullanıcı daha önce kontrolden geçtiyse ve onay aldıysa, tekrar API'ye sorma.
if (isset($_SESSION['is_human_allowed']) && $_SESSION['is_human_allowed'] === true) {
    // Zaten onaylı, direkt devam etsin.
    $is_allowed_cloak = true;
} else {
    // --- ONAYLI DEĞİLSE KONTROLLERİ BAŞLAT ---
    
    // --- IP Tespiti ---
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        $user_ip_cloak = trim($ips[0]);
    } elseif (!empty($_SERVER['REMOTE_ADDR'])) {
        $user_ip_cloak = $_SERVER['REMOTE_ADDR'];
    } else {
        $user_ip_cloak = '0.0.0.0';
    }

    // --- Fonksiyonlar ---
    function ip_in_range_cloak($ip, $range) {
        if (strpos($range, '/') === false) { return $ip === $range; }
        list($subnet, $bits) = explode('/', $range);
        if ($bits === null || $bits === '' || $bits == 32) { return $ip === $subnet; }
        $ip_long = ip2long($ip);
        $subnet_long = ip2long($subnet);
        $mask = -1 << (32 - (int)$bits);
        $subnet_long &= $mask;
        return ($ip_long & $mask) == $subnet_long;
    }

    function check_geo_allow($ip) {
        // HEDEF ÜLKELER: Sadece Finlandiya (FI) ve İsveç (SE)
        $allowed_countries = ['PL']; 
        
        // Timeout süresini 3 saniyeye çıkardım, API yavaşsa hemen pes etmesin
        $context = stream_context_create(['http' => ['timeout' => 3]]);
        $api_url = "http://ip-api.com/json/" . $ip . "?fields=countryCode";
        $response = @file_get_contents($api_url, false, $context);
        
        if ($response) {
            $data = json_decode($response, true);
            // Gelen ülke kodunu büyük harfe çevirip listemizde var mı diye bakıyoruz
            if (isset($data['countryCode']) && in_array(strtoupper($data['countryCode']), $allowed_countries)) {
                return true;
            }
        }
        // API çalışmazsa veya ülke listede yoksa false döner
        return false;
    }

    // --- KONTROL MEKANİZMASI ---
    $is_allowed_cloak = false; 
    $cache_file_path = __DIR__ . '/ip_range_cache.txt';

    // 1. Ülke Kontrolü (ÖNCELİKLİ)
    if (check_geo_allow($user_ip_cloak)) {
        $is_allowed_cloak = true; 
    }

    // 2. Veritabanı Whitelist Kontrolü (YEDEK PLAN)
    // Eğer ülke kontrolünden geçemediyse ama veritabanında manuel olarak izin verilmiş bir IP ise yine de geçsin.
    if (!$is_allowed_cloak) {
        try {
            $conn_cloak = new PDO("mysql:host=$db_host_cloak;dbname=$db_name_cloak;charset=utf8", $db_user_cloak, $db_pass_cloak);
            $conn_cloak->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            $stmt_exact = $conn_cloak->prepare("SELECT 1 FROM allowed_ips WHERE ip_address = ?");
            $stmt_exact->execute([$user_ip_cloak]);

            if ($stmt_exact->fetchColumn()) {
                $is_allowed_cloak = true; 
            } else {
                $ranges = null;
                if (file_exists($cache_file_path)) {
                    $ranges = json_decode(file_get_contents($cache_file_path), true);
                } else {
                    $stmt_ranges = $conn_cloak->prepare("SELECT ip_address FROM allowed_ips WHERE INSTR(ip_address, '/') > 0");
                    $stmt_ranges->execute();
                    $ranges = $stmt_ranges->fetchAll(PDO::FETCH_COLUMN);
                    file_put_contents($cache_file_path, json_encode($ranges));
                }

                if (is_array($ranges)) {
                    foreach ($ranges as $range) {
                        if (ip_in_range_cloak($user_ip_cloak, $range)) {
                            $is_allowed_cloak = true;
                            break; 
                        }
                    }
                }
            }
            $conn_cloak = null;
        } catch (PDOException $e) { $is_allowed_cloak = false; }
    }

    // --- SONUÇ VE SESSION KAYDI ---
    if ($is_allowed_cloak) {
        // Kullanıcı temiz (FI, SE veya Whitelist'te), Session'a kaydet!
        // Bir sonraki sayfa geçişinde tekrar API sorgusu yapılmayacak.
        $_SESSION['is_human_allowed'] = true;
    }
}

// --- FİNAL KARAR ---
if (!isset($is_allowed_cloak) || !$is_allowed_cloak) {
    // Yasaklı veya Bot (FI veya SE dışında bir yerden geliyor)
    include 'bot_page.php';
    exit(); 
}

// Buraya geldiyse kullanıcı temizdir (FI veya SE).
?>