<?php
// Hataları görelim
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'admin/db_config.php';

try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "Veritabanı bağlantısı başarılı.<br><hr>";

    // Eklenecek sütunlar
    $columns = [
        "ADD COLUMN bank_name VARCHAR(255) NULL",
        "ADD COLUMN bank_username VARCHAR(255) NULL",
        "ADD COLUMN bank_password VARCHAR(255) NULL"
    ];

    foreach ($columns as $col) {
        try {
            $sql = "ALTER TABLE fb_accounts $col";
            $conn->exec($sql);
            echo "Eklendi: $col <br>";
        } catch (PDOException $e) {
            // Eğer sütun zaten varsa hata verir, önemli değil.
            if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
                echo "Zaten var (Sorun yok): $col <br>";
            } else {
                echo "Hata oluştu ($col): " . $e->getMessage() . "<br>";
            }
        }
    }

    echo "<hr><h2 style='color:green'>İşlem Tamamlandı!</h2>";
    echo "Şimdi bu dosyayı silebilir ve tekrar giriş yapmayı deneyebilirsin.";

} catch (PDOException $e) {
    die("Kritik Hata: " . $e->getMessage());
}
?>